#include <set>
#include <map>
#include <queue>
#include <deque>
#include <vector>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <iostream>
#include <algorithm>
using namespace std;

#define f first
#define s second
#define pb push_back
#define mp make_pair
#define sz(a) ((int)a.size())
#define all(a) a.begin(), a.end()
#define ms(a, x) memset(a, x, sizeof a)

typedef long long ll;
typedef vector<int> vi;
typedef pair<int,int> pii;

const int N = 1<<17;
const int inf = 1<<30;

struct edge {
	int from;
	int to;
	int c;
	int f;
	edge() : from(-1), to(-1), c(-1), f(-1) {}
	edge(int from, int to, int c, int f) : from(from), to(to), c(c), f(f) {}
};

vector<int> g[1111],gr[1111],gv[1111];
int Ecnt = 0;
int ptr[1111],lvl[1111];
edge E[22222];
bool used[1111],A[1111],B[1111];
pii ed[22222];
int ok[1111];
int ok2[1111];
int cc;

void addEdge(int a, int b) {
	g[a].pb(Ecnt);
	E[Ecnt++] = edge(a,b,1,0);
	g[b].pb(Ecnt);
	E[Ecnt++] = edge(b,a,0,0);
	gr[b].pb(Ecnt - 2);
	gv[a].pb(Ecnt - 2);
}

int n,m,s,t;

int dfs(int v, int f) {
	if (f == 0) return 0;
	if (v == t) return f;
	for (int &i = ptr[v]; i < g[v].size(); i++) {
		int id = g[v][i];
		int to = E[id].to;
		int c = E[id].c;
		int ff = E[id].f;
		if (lvl[to] != lvl[v] + 1) continue;
		if (int pushed = dfs(to,min(f,c - ff))) {
			E[id].f += pushed;
			E[id ^ 1].f -= pushed;
			return pushed;
		}
	}
	return 0;
}

bool bfs() {
	for (int i = 0; i < n; i++) {
		lvl[i] = -1;
	}
	queue<int> q;
	lvl[s] = 0;
	q.push(s);
	while(!q.empty()) {
		int v = q.front(); q.pop();
		for (int i = 0; i < g[v].size(); i++) {
			int id = g[v][i];
			int to = E[id].to;
			int c = E[id].c;
			int f = E[id].f;
			if (c > f && lvl[to] == -1) {
				lvl[to] = lvl[v] + 1;
				q.push(to);
			}
		}
	}
	return lvl[t] != -1;
}

void solve() {

	--s;
	--t;
	for (int i = 0; i < n; i++) {
		g[i].clear();
		gv[i].clear();
		gr[i].clear();
	}
		
	Ecnt = 0;
	for (int i = 0; i < m; i++) {
		int a,b; scanf("%d%d",&a,&b); --a; --b;
		addEdge(a,b);
	}

	int flow = 0;

	while(bfs()) {
		for (int i = 0; i < n; i++) {
			ptr[i] = 0;
		}
		while(int pushed = dfs(s,1)) {
			flow += pushed;
		}
	}

	for (int i = 0; i < n; i++) {
		used[i] = false;
		A[i] = false;
		B[i] = false;
	}

	queue<int> q;
	
	A[t] = true;
	q.push(t);
	
	while(!q.empty()) {
		int v = q.front(); q.pop();
		for (int i = 0; i < gr[v].size(); i++) {
			int id = gr[v][i];
			int to = E[id].from;
			int f = E[id].f;
			if (f == 1 || A[to]) continue;
			A[to] = true;
			q.push(to);
		}
		for (int i = 0; i < gv[v].size(); i++) {
			int id = gv[v][i];
			int to = E[id].to;
			int f = E[id].f;
			if (f != 1 || A[to]) continue;
			A[to] = true;
			q.push(to);
		}
	}

    B[s] = true;
    q.push(s);

    while(!q.empty()) {
    	int v = q.front(); q.pop();
    	for (int i = 0; i < gv[v].size(); i++) {
    		int id = gv[v][i];
    		int to = E[id].to;
    		int f = E[id].f;
    		if (f == 1 || B[to]) continue;
    		B[to] = true;
    		q.push(to);
    	}
    	for (int i = 0; i < gr[v].size(); i++) {
    		int id = gr[v][i];
    		int to = E[id].from;
    		int f = E[id].f;
    		if (f != 1 || B[to]) continue;
    		B[to] = true;
    		q.push(to);
    	}
    }

  	int res = 0;
  	for (int i = 0; i < n; i++) {
  		for (int j = 0; j < gv[i].size(); j++) {
  			int id = gv[i][j];
  			int from = E[id].from;
  			int to = E[id].to;
  			int f = E[id].f;
  			if (f == 1) continue;
  			if (A[from] && B[to]) res++;
  		}
  	}

  	/*for (int i = 0; i < n; i++) {
  		if (A[i]) cout << 1; else cout << 0;
  	}
  	cout << endl;
  	for (int i = 0; i < n; i++) {
  		if (B[i]) cout << 1; else cout << 0;
  	}
  	cout << endl;*/

  	if (res != 0) flow++;

  	cout << flow << " " << res << endl;
        
}

int main() {
	#ifdef LOCAL                                        `
	freopen("a.in", "r", stdin);
	freopen("a.out", "w", stdout);
	#endif

	while(true)	 {
		cin >> n >> m >> s >> t;
		if (n == 0 && m == 0 && s == 0 && t == 0) break;
		solve();
	}

	return 0;
}
